import acm.program.*;
import acm.util.*;
import java.util.*;
import java.io.*;

public class ExploreTheUS extends ConsoleProgram {
	/* The name of the US cities file. */
	private static final String CITIES_FILE = "us-cities.txt";
	
	public void run() {
		/* We need a big font... this is America we're talking about! */
		setFont("DejaVuSerif-BOLD-24");
		
		HashMap<String, City> cities = readUSCities();
		while (true) {
			/* Get the city and convert its name to lower case for use in the
			 * map.
			 */
			String cityName = readLine("Enter a city name: ").toLowerCase();
			
			/* If we know the city, display it! */
			if (cities.containsKey(cityName)) {
				println(cities.get(cityName));
			}
			/* Otherwise, say that we don't know it. */
			else {
				println("Sorry, I don't know that city.");
			}
		}
	}
	
	/**
	 * Reads in the data file of US cities and hands back all the cities
	 * it contains.
	 * 
	 * @return A view of all US cities.
	 */
	private HashMap<String, City> readUSCities() {
		try {
			HashMap<String, City> result = new HashMap<String, City>();
			BufferedReader br = new BufferedReader(new FileReader(CITIES_FILE));
			
			while (true) {
				/* Read the three pieces of the city from the file. */
				String name = br.readLine();
				String latitude = br.readLine();
				String longitude = br.readLine();
				
				/* If we ran out of data, we're done. */
				if (longitude == null)
					break;
				
				/* Create the city and add it to the result list.  Note the
				 * call to Double.parseDouble to convert the string representations
				 * of the longitude and latitude into doubles.
				 */
				City toAdd = new City(name,
						              Double.parseDouble(longitude),
						              Double.parseDouble(latitude));
				
				/* Add the city to the map, making the name lower case so that we can
				 * look it up consistently.
				 */
				result.put(toAdd.getName().toLowerCase(), toAdd);
			}
			
			br.close();
			return result;			
		} catch (IOException e) {
			throw new ErrorException(e);
		}
	}
}
